#include <windows.h>
#include "z64.h"
#include "Gfx #1.3.h"
#include "vi.h"
#include "rdp.h"
#include "bitmap.h"

HGLRC render_context;
HDC device_context;

HRESULT res;
RECT dst, src;
INT32 pitchindwords;

static const GLshort zero_xyzw_MMX[4] = {
    0x0000, 0x0000, 0x0000, 0x0000
};
static const GLfloat zero_xyzw_SSE1[4] = {
    0.0F, 0.0F, 0.0F, 0.0F
};
static const GLdouble zero_xy_SSE2[2] = {
    0.0, 0.0
};

const PIXELFORMATDESCRIPTOR pixel_format = {
    sizeof(PIXELFORMATDESCRIPTOR), /* nSize */
    0x0001, /* nVersion */
    PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DEPTH_DONTCARE /* dwFlags */
#ifdef _DEBUG
| PFD_DOUBLEBUFFER, /* for testing purposes only */
#else
| PFD_DOUBLEBUFFER_DONTCARE, /* Maybe single-buffered; SwapBuffers() in case. */
#endif
    PFD_TYPE_RGBA, /* iPixelType */
    32, /* cColorBits */

    0, 0,
    0, 0,
    0, 0,
    0, 0,

    0,
    0, 0, 0, 0,

    0, /* cDepthBits */
    0, /* cStencilBits */
    0, /* cAuxBuffers */
    PFD_MAIN_PLANE, /* iLayerType */

    0x00, /* bReserved */
    0x00000000, /* dwLayerMask */
    0x00000000, /* dwVisibleMask */
    0x00000000, /* dwDamageMask */
};

FILE* zeldainfo = 0;
int ProcessDListShown = 0;
extern int SaveLoaded;
extern UINT32 command_counter;

GFX_INFO gfx;

static char filepath[_MAX_PATH];

EXPORT void CALL CaptureScreen(char * Directory)
{
    static unsigned short count;
    register int i;

    for (i = 0; i < _MAX_PATH; i++)
        if (Directory[i] == '\0')
            break;
        else
            filepath[i] = *(Directory + i);
    if (i + 12 >= _MAX_PATH)
    {
        MessageBox(NULL, "Screenshots directory too long.", NULL, MB_ICONERROR);
        return;
    }
    filepath[i] = GET_GFX_INFO(HEADER)[0x3B ^ BYTE_ADDR_XOR];
    filepath[i++] = (filepath[i] == '\0') ? ' ' : filepath[i];
    filepath[i] = GET_GFX_INFO(HEADER)[0x3C ^ BYTE_ADDR_XOR];
    filepath[i++] = (filepath[i] == '\0') ? ' ' : filepath[i];
    filepath[i] = GET_GFX_INFO(HEADER)[0x3D ^ BYTE_ADDR_XOR];
    filepath[i++] = (filepath[i] == '\0') ? ' ' : filepath[i];
    filepath[i] = GET_GFX_INFO(HEADER)[0x3E ^ BYTE_ADDR_XOR];
    filepath[i++] = (filepath[i] == '\0') ? ' ' : filepath[i];
    filepath[i++] = '0' | (count/1000 % 10);
    filepath[i++] = '0' | (count/ 100 % 10);
    filepath[i++] = '0' | (count/  10 % 10);
    filepath[i++] = '0' | (count/   1 % 10);
    filepath[i++] = '.';
    filepath[i++] = 'b';
    filepath[i++] = 'm';
    filepath[i++] = 'p';
    filepath[i] = '\0';
    capture_screen_to_file[*GET_GFX_INFO(VI_STATUS_REG) & 0x00000001](filepath);
    count = (count + 0x0001) % 10000;
    if (count == 9999)
    {
        MessageBox(
            NULL, "Screenshots directory is about to overflow.", "Warning",
            MB_ICONWARNING);
    }
    return;
}

/*
 * based on the Win32 full-screen implementation written by zilmar in his
 * basic CFB plugin
 */
int is_full_screen = 0;
EXPORT void CALL ChangeWindow(void)
{
    static WINDOWPLACEMENT wndpl;
    static HMENU old_menu;
    static LONG old_style;
    int dimensions[2] = { 0 };
    const HWND hWnd = GET_GFX_INFO(hWnd);
    const HWND hStatusBar = GET_GFX_INFO(hStatusBar);

    if (is_full_screen == 0)
    {
        is_full_screen = 1;
        get_screen_size(dimensions);

        wndpl.length = sizeof(wndpl);
        GetWindowPlacement(hWnd, &wndpl);

        if (hStatusBar)
            ShowWindow(hStatusBar, SW_HIDE);
        old_menu = GetMenu(hWnd);
        if (old_menu)
            SetMenu(hWnd, NULL);
        old_style = GetWindowLong(hWnd, GWL_STYLE);
        SetWindowLong(hWnd, GWL_STYLE, WS_VISIBLE);
        SetWindowPos(
            hWnd, HWND_TOPMOST, 0, 0, dimensions[0], dimensions[1],
            SWP_SHOWWINDOW);
        ShowCursor(FALSE);
        sync = TRUE;
    }
    else
    {
        is_full_screen = 0;
        switch (cfg[4])
        {
            case 0x00:
                dimensions[0] = 640;
                dimensions[1] = 480;
                break;
            case 0x01:
                dimensions[0] = hres_old;
                dimensions[1] = vres_old;
                break;
            case 0x02:
                dimensions[0] = (cfg[0] << 8) + cfg[1] + 1;
                dimensions[1] = (cfg[2] << 8) + cfg[3] + 1;
                break;
            default:
                DisplayError("Invalid resolution control setting.");
                break;
        }

        if (hStatusBar)
            ShowWindow(hStatusBar, SW_SHOW);
        if (old_menu)
        { 
            SetMenu(hWnd, old_menu);
            old_menu = NULL;
        }
        SetWindowLong(hWnd, GWL_STYLE, old_style);
        SetWindowPos(
            hWnd, HWND_NOTOPMOST, wndpl.rcNormalPosition.left,
            wndpl.rcNormalPosition.top, dimensions[0], dimensions[1],
            SWP_NOSIZE | SWP_SHOWWINDOW);
        ShowCursor(TRUE);
        sync = TRUE;
    }
    return;
}

EXPORT void CALL CloseDLL(void)
{
    BOOL pass;
    HDC current_DC;
    HGLRC current_RC;

    current_RC = wglGetCurrentContext();
    if (current_RC != render_context)
    {
        GLenum error;

        if (current_RC == NULL)
            return;
        error = glGetError();
        DisplayGLError("CloseDLL", error);
    }
    device_context = NULL;

    pass = wglMakeCurrent(device_context, NULL);
    current_DC = wglGetCurrentDC();
    if (pass == FALSE || current_DC != NULL)
        DisplayError("Failed to free OpenGL render context.");

    pass = wglDeleteContext(render_context);
    current_RC = wglGetCurrentContext();
    if (pass == FALSE || current_RC != NULL)
        DisplayError("Failed to delete OpenGL render context.");
    return;
}

EXPORT void CALL ReadScreen(void **dest, long *width, long *height)
{
}

EXPORT void CALL DrawScreen (void)
{
}

EXPORT void CALL GetDllInfo(PLUGIN_INFO* PluginInfo)
{
    PluginInfo -> Version = 0x0103;
    PluginInfo -> Type  = PLUGIN_TYPE_GFX;
strcpy(
    PluginInfo -> Name, "angrylion's RDP (OpenGL 1.0 beta)"
);
    PluginInfo -> NormalMemory = TRUE;
    PluginInfo -> MemoryBswaped = TRUE;
    return;
}

EXPORT BOOL CALL InitiateGFX(GFX_INFO Gfx_Info)
{
    GLenum error;
    BOOL pass;
    int pixel_format_enum;

    device_context = GetDC(Gfx_Info.hWnd);
    if (device_context == NULL)
    {
        DisplayError("Failed to get device context from render window.");
        return FALSE;
    }

    pixel_format_enum = ChoosePixelFormat(device_context, &pixel_format);
    if (pixel_format_enum == 0)
    {
        DisplayError("No suitable pixel format detected on this system.");
        return FALSE;
    }

    pass = SetPixelFormat(device_context, pixel_format_enum, &pixel_format);
    if (pass == FALSE)
    {
        DisplayError("Failed to set detected pixel format.");
        return FALSE;
    }

/*
 * begin initialization of OpenGL over Windows
 */
    render_context = wglCreateContext(device_context);
    if (render_context == NULL)
    {
        DisplayError("Failed to get OpenGL render context from DC.");
        return FALSE;
    }

    pass = wglMakeCurrent(device_context, render_context);
    if (pass == FALSE)
    {
        DisplayError("Failed to set valid render context.");
        return FALSE;
    }

    error = glGetError();
    if (error != GL_NO_ERROR)
    {
        DisplayGLError("InitiateGFX", error);
        return FALSE;
    }

    gfx = Gfx_Info;
    return TRUE;
}

EXPORT void CALL MoveScreen(int xpos, int ypos)
{
    RECT statusrect;
    POINT p;

    p.x = p.y = 0;
    GetClientRect(gfx.hWnd, &dst);
    ClientToScreen(gfx.hWnd, &p);
    OffsetRect(&dst, p.x, p.y);
    GetClientRect(gfx.hStatusBar, &statusrect);
    dst.bottom -= statusrect.bottom;
}

static unsigned char list_called_count = 0x00;
EXPORT void CALL ProcessDList(void)
{
    if (list_called_count < cfg[15])
    {
        ++list_called_count;
        return;
    }
    list_called_count = 0x00;

    if (!ProcessDListShown)
    {
        DisplayError("ProcessDList");
        ProcessDListShown = 1;
    }
}

EXPORT void CALL ProcessRDPList(void)
{
    if (list_called_count < cfg[15])
    {
        ++list_called_count;
        return;
    }
    list_called_count = 0x00;

    process_RDP_list();
    return;
}

EXPORT void CALL RomClosed(void)
{
    rdp_close();
    SaveLoaded = 1;
    command_counter = 0;
    file_out("RDP_CONF.BIN", cfg, 32);
    return;
}

EXPORT void CALL RomOpen(void)
{
    HGLRC current_RC;
    GLenum error;
    BOOL pass;
    RECT status_bar = { 0 };

    current_RC = wglGetCurrentContext();
    while (current_RC != render_context)
    { /* recursion hack for Project64's threading life cycle problems */
        pass = InitiateGFX(gfx);
        if (pass == FALSE)
            DisplayError("Failed to initialize OpenGL context.");
        else
            current_RC = wglGetCurrentContext();
    }
    if (gfx.hStatusBar != NULL)
        GetClientRect(gfx.hStatusBar, &status_bar);

    screen_resize(640, 480);
    glViewport(status_bar.left, status_bar.bottom, 640, 480);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    glColor3d(0.0, 1.0, 0.0);
    glRasterPos2d(-1., +1.);
    glColor3d(1.0, 1.0, 1.0);

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_CULL_FACE);

    glClearColor(0.f, 0.f, 0.f, 0.f);
    glClear(GL_COLOR_BUFFER_BIT);
    pass = SwapBuffers(device_context);
    if (pass == FALSE)
        DisplayError(
            "Swapping buffers seems to fail.\n"\
            "Hope your device doesn't multi-buffer!");

    glClearColor(1.f, 0.f, 1.f, 5.f);
    glEnable(GL_TEXTURE_2D);

    pitchindwords = PRESCALE_WIDTH / 1;
    error = glGetError();
    if (error != GL_NO_ERROR)
        DisplayGLError("Failed to test OpenGL context.", error);

    rdp_init();
    pass = file_in("RDP_CONF.BIN", cfg, 32);
    if (pass == FALSE)
        DisplayError("Could not open `RDP_CONF.BIN'.");
    return;
}

EXPORT void CALL ShowCFB(void)
{
    MessageBox(NULL, "ShowCFB", NULL, MB_ICONWARNING);
    UpdateScreen();
    return;
}

static unsigned char called_count;
EXPORT void CALL UpdateScreen(void)
{
    if (called_count < cfg[14])
    {
        ++called_count;
        return;
    }
    called_count = 0x00;

    rdp_update();
    glFlush();
    SwapBuffers(device_context);
    if (cfg[23] & 0x04)
        MessageBox(NULL, "Updated screen.\nPaused.", "Frame Step", MB_OK);
    return;
}

EXPORT void CALL ViStatusChanged(void)
{
}

EXPORT void CALL ViWidthChanged(void)
{
    glClear(GL_COLOR_BUFFER_BIT);
    sync = TRUE;
    return;
}

EXPORT void CALL FBWrite(DWORD addr, DWORD size)
{
    return;
}

EXPORT void CALL FBWList(FrameBufferModifyEntry *plist, DWORD size)
{
}

EXPORT void CALL FBRead(DWORD addr)
{
}

EXPORT void CALL FBGetFrameBufferInfo(void *pinfo)
{
}
